#pragma rtGlobals=1		// Use modern global access method.
#include <Strings as Lists>

#include <Concatenate Waves>
#include "IR1_Loader"
#include "IN2_GeneralProcedures"
//  miromeritics Output from version 1.08
//Open the sample file.
//Go to report options.  Check 
//	combined report. 
//	Background	
//	Goodness of fit
// Edit combined report and only check 
//	Frequency Graph
//	Summary
//Edit goodness of fit and edit
//	scattering vector
//	Overlay model fit (cant do multiple datasets)

//The software is in the Snap drive under "Software", then "Micromeritics". 
//Install 1.08 first and then 1.09. When you are finished, open the software. 
//Go to "Reports" then "Start Reports" and select your files. 
//You can select all of them at once to make it easier and faster. 
//To save as text file, click save as. 
//Once the report is generated it should make the PAR file. Let me know if you have problems.

//work on number loading, currently already tries to make folder with same data name
	
Menu "Plot&Fit"
	 Submenu "Reflectivity Tools"
	"-"
		"load 4col to Irena and Motofit /4",LoadLR_Mantid()
		"-"
		"load SNS LR IDL Scaled",  SNS_LR_load_Scaled()
		"Load Asterix Scaled",LANL_AX_load_Scaled()
	end
end


menu "Data"
	"-"
	"Generic 1d Loader", load1d(0,2,2,2,4,4,".dsm",1)//(newfolder,qdisplay,nm,nameline,headerlines,nocols,filetype)
	"Generic Load Header", loadHeader(-1,100,".txt")//(nameline,headerlines,filetype)
//	"Load Excel Macosko",loadmacosko_excel()
	"-"
//	"Load Instron", loadinstrontxt()	
	 "-"

	 Submenu "Light Scattering"
		SUBMENU "Mastersizer 2000"
			"Load Mastersizer2000 excel", loadmastersizer2000excel()
			"Load Mastersizer2000 text", loadmastersizer2000text()
		end
		submenu "Micromeritics"
		//  	"Load micromeritics text file DWS", loadMicromeriticsDWS()
     		//	"Load micromeritics text file V1.06",loadMicromeriticsV1_06()
     		//	"Load micromeritics text file V1.08", loadMicromeriticsV1_08TXT()	
     		//	"Load micromeritics text file V1.09",loadMicromeriticsV1_09TXT()
     		//	"Load micromeritics Ryan",loadMicromeriticsV1_08temp()
     			"Load Micromeritics Doug",Loadmicromeriticsdoug()
     			"-"
     			"Print all foldernames and obscuration",  PrintNamesMicromeritics_all()
			"Cleanup Micromeritics Names", FixAllFolderAndWaveNames()	
		//	"Plot regenerator 1.08", Plotregenerator108()
		//	"Plot regenerator 1.09", Plotregenerator109()
		end

		//	"Load Horiba 910",LoadHoriba910()
			//"Multiply q by 1.33",fixq()//refractive index correction for old data
			//"Unfudge detector 20,22,24",fixratio()//arbitrary shif for large angle detectors

		"Load Mie", loadMie()
	//	"Load Excel LS230",loadLS230_excel()
	end
	"-"

		submenu "LANL LQD Data"
			"Load 1d LANL LQD Data",load1dLANL_SANS()
			"Load 1d LANL LQD .csv/4",Load1dLANL_CSV()
		end
		
//	end
	submenu "Reflectivity"
		"Load Panalytical Reflectivity",load1d(0,2,3,1,0,2,"TEXT",1)
		"Load .udf reflectivity data", loadUDF_Panalytical(2,1)	//1 for q (-1), 0 for TTH ()
		"Load .XRDml refectivity data", loadXRDml_Panalytical(2,1)	
		"-"
		"Load Rigaku .dat", LoadRigakuDAT()
		"Load Rigaku .asc",loadRigakuASC()
		"Load Rigaku .txt",LoadRigakuTXT()
		"-"
		"Spec Reflectivity Loader",SPEC_ImportPanilInitialize()
		"-"
		//submenu "Parratt"
			"Load Parratt 3 cols.dat",load1d(1,2,2,10000,0,3,".dat",1)
			"Load Parratt SLD .pro",load1d(2,2,2,10000,0,2,".pro",1)
			"Load Parratt .dat, .pro and .par",LoadParratt_SLD(1)//load1d(2,2,10000,0,2,".pro",1)
		//	"Shift SLD profile",Shiftprofile()
		//	"Shift ILAVSKY SLD profile",ShiftIlavskyProfile()
	//	End
	end
end

function LoadLR_Mantid()
	string filetype, qwavename,swavename,wwavename,rwavename
	if (!DataFolderExists( "root:Packages:ReflectivityTool"))
		if (!DataFolderExists( "root:Packages"))
			newdatafolder root:Packages
		endif
		newdatafolder root:Packages:ReflectivityTool
	endif
	If (!DataFolderExists("root:data") )
			Newdatafolder root:data
		endif
	
	load1d(1,2,2,10000,3,4,".txt",0)//newfolder,qdisplay,nm,nameline,headerlines,nocols,filetype,dialog	
	SVAR basename
	Rwavename="r"+basename
	Qwavename="q"+basename
	Swavename="s"+basename
	Wwavename="w"+basename
	wave rwave= $rwavename
	wave qwave= $qwavename
	wave swave=$swavename
	wave wwave=$wwavename
		Newdatafolder/o/S root:data:$"L"+basename
		
		variable n1=numpnts(qwave)
		make/o/N=(n1,4)/O originaldata
		originaldata[][0]=qwave[p]
		originaldata[][1]=rwave[p]
		originaldata[][2]=swave[p]
		if (Waveexists(Wwave))
			originaldata[][3]=Wwave[p]
		else
			originaldata[][3]=1
		endif
		Redimension/D originaldata	
end
	



function loadmicromeriticsdoug()
		silent 1

		string/g filename,fullpath, filestring,testlist,tempname,qresultname,rresultname,sresultname,notebookname,header,lineread,headerwavename
		variable/g summary_plc, goodness_plc,bckgrn_plc,model_plc,file_len,pd_plc
		variable refno,count,testnum,filecharpos,searchplace,ncount,scanpos,linecount,numberonly,v_flag
		string samplename,headerpanel,subfoldername
		filename=""
		filestring=""
		header=""
		lineread=""
		subfoldername=""
		numberonly=0
		v_flag=0

		setdatafolder root:
		open /r/t="????" refno as filename
		fullpath = s_filename
		if (v_flag==-1)
			abort 
		endif

		scanpos=0
		do 
			Freadline refno, lineread
			header+=lineread
			count+=1
			if (stringmatch(lineread, "*Sample:*"))
				samplename=lineread[16,inf]
			endif
			if (stringmatch(lineread,"*Test Number*"))
				if (strsearch(lineread, "Avg",0)==-1)
					testnum=str2num(lineread[28])
					ncount=0
				else
					testnum=str2num(lineread[24,25])
					ncount=testnum+1
				endif
			endif
		while(count<19)

		fsetpos refno,0
		Freadline /T="" refno,filestring
		filestring=replacestring(num2char(10),filestring,"")
		file_len=strsearch(filestring,"Micromeritics Export",100)
		summary_plc=strsearch(filestring,"Summary Report",0)
		header+=filestring[summary_plc,file_len]
		samplename=replacestring(" ",samplename,"")
		samplename=removeending(samplename)

//newpanel /k=1/n=SampleInformation
//titlebox tb1, variable=header
//pauseforuser SampleInformation
		prompt samplename, "Is samplename correct?"
		doprompt "Is sample name correct?", samplename

		if (strlen(samplename)>18)
			do
				prompt samplename, "SAMPLENAME MUST BE LESS THAN 19 CHARACTERS"
				doprompt "SAMPLE NAME MUST BE LESS THAN 19 CHARACTERS", samplename
				if (V_flag==1)
				break
				endif
			while (strlen(samplename)>18)
		endif
		if (V_flag==1)
			abort 
		endif

headerwavename= samplename+"_header"
newdatafolder/O/S$samplename
make/T/n=1$headerwavename
note $headerwavename,header
print note($headerwavename)
notebookname="File Header Information"
newnotebook /k=1/n=headerinformation /F=1
notebook headerinformation, text=header

count=1
testlist="Average"
do
testlist+=";"+"Test" + num2str(count)
count+=1
while (count<=testnum)

ncount=0

goodness_plc=strsearch(filestring,"Goodness of Fit",0)
bckgrn_plc=strsearch(filestring,"Background Intensity",0)
model_plc=strsearch(filestring,"Model Intensity",0)
pd_plc=strsearch(filestring,"Particle Diameter",0)

linecount=0
if (strsearch(filestring,"Particle Diameter",0)!=-1)
do 
scanpos=strsearch(filestring,"\r",scanpos+1)
linecount+=1
while (scanpos<pd_plc)

If (strsearch(filestring, "Number Frequency",0)!=-1)
subfoldername=":NumberFrequency"
newdatafolder/o/s $subfoldername
qresultname="q_"
rresultname="r_"
sresultname="s_"
numberonly=1
else
subfoldername=  ":VolumeFrequency"
newdatafolder/o/s $subfoldername
qresultname="q_"
rresultname="r_"
sresultname="s_"
endif

do	
	Loadwave /n=w/g/k=1/L={0,linecount,500,0,2} fullpath
	linecount+=dimsize(w0,0)+3
	tempname=qresultname +samplename+"_"+stringfromlist(ncount,testlist)
	duplicate/o w0, $tempname; killwaves w0	
	duplicate/o w1,w2
	w2*=0.01
	tempname=rresultname+samplename+"_"+stringfromlist(ncount,testlist)
	duplicate/o w1,$tempname; killwaves w1
	tempname=sresultname+samplename+"_"+stringfromlist(ncount,testlist)
	duplicate/o w2,$tempname; killwaves w2
	ncount+=1
	while (ncount<testnum+1)
	ncount=0
	if (numberonly==1)
	abort
	endif
endif

if (strsearch(filestring,"Weighted Residual",0)!=-1)
filecharpos=goodness_plc
qresultname="q_"
rresultname="r_"
sresultname="s_"
linecount+=4
setdatafolder root:$samplename
subfoldername=":IvsQ"
newdatafolder/o/s $subfoldername
do	
	Loadwave /n=w/g/k=1/L={0,linecount,500,0,2} fullpath
	linecount+=dimsize(w0,0)+3
	tempname=qresultname +samplename+"_"+stringfromlist(ncount,testlist)
	duplicate/o w0, $tempname; killwaves w0	
	duplicate/o w1,w2
	w2*=0.01
	tempname=rresultname+samplename+"_"+stringfromlist(ncount,testlist)
	duplicate/o w1,$tempname; killwaves w1
	tempname=sresultname+samplename+"_"+stringfromlist(ncount,testlist)
	duplicate/o w2,$tempname; killwaves w2
	ncount+=1
	while (ncount<testnum+1)
	ncount=0
endif

if (strsearch(filestring,"Background Intensity",0)!=-1)
setdatafolder root:$samplename
subfoldername= ":Background"
newdatafolder/o/s $subfoldername
filecharpos=bckgrn_plc
ncount=testnum+1
qresultname="q_bck_"
rresultname="r_bck_"
sresultname="s_bck_"
linecount+=4
do	
	Loadwave /n=w/g/k=1/L={0,linecount,500,0,2} fullpath
	linecount+=dimsize(w0,0)+3
	tempname=qresultname +samplename+"_"+stringfromlist(ncount,testlist)
	duplicate/o w0, $tempname; killwaves w0	
	duplicate/o w1,w2
	w2*=0.01
	tempname=rresultname+samplename+"_"+stringfromlist(ncount,testlist)
	duplicate/o w1,$tempname; killwaves w1
	tempname=sresultname+samplename+"_"+stringfromlist(ncount,testlist)
	duplicate/o w2,$tempname; killwaves w2
	ncount+=1
	while (ncount<testnum+1)
	ncount=0
endif


setdatafolder root:

close refno
end



Function CheckforLog()
	SVAR 	ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating
		variable checkedbottom=str2num( stringbykey("log(bottom)",ListOfGraphFormating,"="))
		IR2D_DWSGenPlotCheckBox("GraphLogx",checkedbottom)	
		variable checkedleft=str2num( stringbykey("log(left)",ListOfGraphFormating,"="))
		IR2D_DWSGenPlotCheckBox("GraphLogx",checkedleft)	
		IR2D_DWSGenPlotCheckBox("GraphlogX",checkedbottom)	
		IR2D_DWSGenPlotCheckBox("GraphlogY",checkedleft)	
end		

Function/s Findtrace(type)//"top","bottom" or "tracename"
	string type
	string tracename,tracelist
	tracelist=TraceNameList("", ";", 1 )
		if (stringmatch(type, "top" ))
			tracename=StringFromList(ItemsInList(tracelist)-1, tracelist,";")
		elseif (stringmatch(type, "bottom" ))
			tracename=StringFromList(0, tracelist,";")
		Else//finds a specific trace
			tracename=StringFromList(WhichListItem(type, tracelist), tracelist)//returns null if not present
		Endif
	return tracename
end

function LocateValue(waven, value,Start,LessEqualGreater)		
	string waven
	variable value,LessEqualGreater,start
	Variable N,i,result
	wave w=$waven
	N=numpnts(w)
	for(i=start;i<N;i+=1)
		If(LessEqualGreater==0)			
				result =(w[i]<value	)		
			elseif(LessEqualGreater==1)	
				result =(w[i]==value)
			else
				result= (w[i]>value)
		endif
	
		If(result==1)
			return i
			break							
		endif										
	endfor
end



Function LoadRigakuDAT()//loads .dat files with one run from LANL x-ray reflectometer
	setdatafolder root:
	load1d(1,2,4,-1,36,2,".dat",0)
	SVAR basename
	string qwavename="q"+basename, swavename="s"+basename,rwavename="r"+basename
	variable start ,step
	wave qwave=$qwavename
	wave rwave=$rwavename
	duplicate/o qwave,$swavename
	qwave=qwave/2// convert TTh to Th	
	start = qwave[0]		
	step = qwave[1]-qwave[0]
	qwave=(4*pi/1.5444)*sin(qwave*pi/180)							
	SetScale/P x start,step,"", $rwavename;DelayUpdate//note that scale is in angle, not q.  q is not regular.
	SetScale/P x start,step,"", $qwavename;DelayUpdate
end


Function LoadRigakuTxT()//loads .dat files with one run from LANL x-ray reflectometer	
	setdatafolder root:
	//load1d(newfolder,qdisplay,nm,nameline,headerlines,nocols,filetype,dialog)
	load1d(1,1,4,-1,18,2,".txt",0)
	SVAR basename
	string qwavename="q"+basename, swavename="s"+basename,rwavename="r"+basename
	variable start ,step
	wave qwave=$qwavename
	wave rwave=$rwavename
	duplicate/o qwave,$swavename
	qwave=qwave/2// convert TTh to Th	
	start = qwave[0]		
	step = qwave[1]-qwave[0]
	qwave=(4*pi/1.5444)*sin(qwave*pi/180)							
	SetScale/P x start,step,"", $rwavename;DelayUpdate//note that scale is in angle, not q.  q is not regular.
	SetScale/P x start,step,"", $qwavename;DelayUpdate
end


function loadRigakuASC()//loads .asc files with multiple runs LANL
	variable qloadall=2,linelimit=500
	setdatafolder root:
	variable Counter,length, refno,samplenamelength,rows,start,stop,step,pass=0
	String LineOfNote,theNote,name,samplename,path,fullpath,rwavenamestring,qwavenamestring,swavenamestring
	string/g Root:Packages:P:gfilename
	SVAR filename=Root:Packages:P:gfilename
		Open/R/T=".asc"/m=".asc file only" refno as filename//User picks a file
		getfilename(s_filename)
		fullpath=s_filename
		SVAR filename=Root:Packages:P:gfilename
		SVAR spath=Root:Packages:P:gpath
		NewPath/O temporarypath spath//temporary path is not a defined string
		variable Totaltests=0, qspace=0		
		//put initial lines in note of wave and set up a data folder based on the sample ID in text file
		counter=0
		TheNote=filename+"\r"
		do//get the header information
			FReadLine refNo, LineOfNote	
			TheNote+=LineOfNote
				if (stringmatch(LineofNote, "*Sample*" ))
					samplenamelength =strlen(lineofnote)
					samplename=Getnamechanges(lineofnote[12,samplenamelength-2])
					samplename=CleanupName(samplename,0)	
				endif
			Counter+=1
			if (stringmatch(LineofNote, "*MEMO*" ))//memo is end of header
				break
			endif
		while(1)
		length =strlen(filename)	
		name="R"+samplename
		name=name[0,28]
		NewDataFolder/O/S $name
		String/g Header=TheNote,wavestring=""
		Header= ReplaceString("\t", Header, "");Header= ReplaceString("*", Header, "")
		do//data loading
			FReadLine refNo, LineOfNote	;counter=counter+1		
			if (stringmatch(LineofNote, "*EOF*" ))
				break
			endif
			Pass+=1
			if (stringmatch(LineofNote, "*BEGIN*" ))	
				TheNote=""
				rwavenamestring=name+num2str(counter)
				qwavenamestring="Q"+name[1,100]+num2str(counter)
				swavenamestring="S"+name[1,100]+num2str(counter)
				wavestring=""
				do//get the run information
					FReadLine refNo, LineOfNote	;counter=counter+1		
					TheNote+=LineOfNote
					if (stringmatch(LineofNote, "*Count*" ))
						do			
							FReadLine refNo, LineOfNote	;counter=counter+1	
							if (stringmatch(LineofNote, "*END*" ))
								//Print (num2str(counter))+ "END"
								ConvStr2Wv(wavestring)
								duplicate/o NewWv1,$rwavenamestring,$qwavenamestring,$swavenamestring
								killwaves  NewWv1
								killstrings/z wavestring
								TheNote= ReplaceString("\t", TheNote, "")
								TheNote= ReplaceString("*", TheNote, "")
								Note $rwavenamestring ,TheNote
									start = NumberByKey("start", TheNote, "=","\r")
									stop = NumberByKey("stop", TheNote, "=","\r")
									step = NumberByKey("step", TheNote, "=","\r")
								print start,stop,step
								wave qwave=$qwavenamestring
								qwave=start+step*p
								qwave=qwave/2//data is TTH
								qwave=(4*pi/1.5444)*sin(qwave*pi/180)
								SetScale/P x start/2,step/2,"", $rwavenamestring;DelayUpdate//note that scale is in angle, not q.  q is not regular.
								SetScale/P x start/2,step/2,"", $qwavenamestring;DelayUpdate
								If(pass==2)
									display/k=1 $rwavenamestring vs $qwavenamestring
									ModifyGraph log(left)=1;TextBox/C/N=text0/A=MC name
									Label bottom "q(\\S-1\\M)"
								else
									Appendtograph $rwavenamestring vs $qwavenamestring
								endif							
								break
							endif
							wavestring+=lineofNote[0,strlen(lineofnote)-2]
							wavestring+=", "							
						while(1)	
						break
					endif	
				while(1)
			endif
		while (1)
end



Function LoadMie()//loads mie data from  http://www.philiplaven.com/mieplot.htm
	load1d(1,1,4,-1,17,3,"TEXT",1)
	string rwavename,qwavename,swavename	
	SVAR basename
	qwavename="q"+basename[0,100]
	rwavename="r"+basename[0,100]
	swavename="s"+basename[0,100]
	wave swave=$swavename
	wave qwave=$qwavename
	wave rwave=$rwavename
	duplicate/o qwave,q_perpendicular,q_deg
	duplicate/o rwave, r_perpendicular
	duplicate/o  swave,r_parallel
	duplicate/o qwave,r_PIDS
	wave r_perpendicular,r_parallel
	r_PIDS=r_perpendicular-r_parallel
	variable/g n_medium,radius_um,lambda_um,n_real,n_imag
	
	variable length,start,finish
	string/g wavenote,text
	wavenote =note(r_perpendicular)
	length=strsearch(wavenote, "Radius",0)
	 start =length+7;finish=length+17
	print wavenote[start,finish]
	radius_um=str2num(wavenote[start,finish])
	print radius_um
	text="r = "+num2str(radius_um)+" m"	
	
	
	length=strsearch(wavenote, "Real part",0)
	 start =length+10;finish=length+20
	print wavenote[start,finish]
	n_real=str2num(wavenote[start,finish])
	print n_real
	text+="\r n_real = "+num2str(n_real)
	print text
	
	
	length=strsearch(wavenote, "Wavelength",0)
	 start =length+12;finish=length+18	
	//print wavenote[start,finish]
	Lambda_um=str2num(wavenote[start,finish])
	text+="\rLambda = "+num2str(Lambda_um)+" m"
	
	
	DoWindow /K graph0
	display/k=1 r_perpendicular vs q_perpendicular
	ModifyGraph log=1
	Tag/C/N=radius1,  r_perpendicular,5,text
	q_perpendicular=1e-4*(4*pi*1.33/lambda_um)*sin(q_perpendicular*pi/360)//-1
	killwaves qwave,rwave,swave,wave3,wave4,wave5
end


Function loadLS230_excel()
	string name,foldername,S_filename,comment
	setdatafolder Root:	
	newdatafolder/s/o temp
	doalert 0, "doesn't work with version 6"
	abort
	//XLLoadWave/R=(A13,E5000)/O/K=0/N=w 

	foldername=s_filename
		variable npts=strlen(foldername)-5
	foldername=foldername[0,npts]	
	name=AskName(foldername,foldername,28)
	foldername="X"+name
	string rwavename,qwavename,swavename
	qwavename="q"+name
	rwavename="r"+name
	swavename="s"+name
	duplicate/O w0,$swavename,$rwavename,$qwavename
	wave rw=$rwavename,qw=$qwavename,sw=$swavename	
	wave QforLS230=root:StartupLS230:QforLS230
	qw=QforLS230
	wave w1,w2
	rw=w1
	sw=w1-w2
	killwaves w0,w1,w2,w3,w4
	zapnegatives(qw,rw,sw)	
	string cmd,str
	//str =winName(0,2)//top window is table with name of worksheet
	//killwindow $str

	str=StringFromList(0, WinList(name, ";", "WIN:1"),";")//kills graph it it exists
	killwindow $str
	str="root:"+foldername
	if(DataFolderExists(str))
		 killdatafolder $str	
	endif
	execute ("RenameDataFolder root:temp,"+ foldername)
	Display/k=1 rw vs qw as name	
	ModifyGraph log=1	
	DeletePoints 128,1, qw,rw,sw
	
end

Function loadmacosko_excel()
	string name,foldername,S_filename,comment
	setdatafolder Root:	
	newdatafolder/s/o temp
	doalert 0, "doesn't work with version 6"
	abort
	//XLLoadWave/R=(A3,C5000)/O/T/K=0/N=w 

	foldername=s_filename
		variable npts=strlen(foldername)-5
	foldername=foldername[0,npts]	
	name=AskName(foldername,foldername,28)
	foldername="X"+name
	string rwavename,qwavename,swavename
	qwavename="q"+name;rwavename="r"+name;swavename="s"+name
	duplicate/O w0,$swavename,$rwavename,$qwavename
	wave rw=$rwavename,qw=$qwavename,sw=$swavename
	wave w0,w1,w2,w3,w4,w5,w6,w7,w8,w9,w10,w11
	qw=w0*.1
	rw=w1
	sw=w2
	zapnegatives(qw,rw,sw)	
	string cmd,str
	str =winName(0,2)//top window is table with name of worksheet
	killwindow $str
	killwaves w0,w1,w2,w3,w4,w5,w6,w7,w8,w9,w10,w11
	str=StringFromList(0, WinList(name, ";", "WIN:1"),";")//kills graph it it exists
	killwindow $str
	str="root:"+foldername
	if(DataFolderExists(str))
		 killdatafolder $str	
	endif
	execute ("RenameDataFolder root:temp,"+ foldername)
	Display/k=1 rw vs qw as name	
	ModifyGraph log=1	
end


Function PrintNamesMicromeritics_all()
	ScanAllFolders("root:", 4,"ReturnFolderName()")
end


Function ReturnFolderName()//  here
		NVAR obscuration
		print GetDataFolder(0) +("    obscuration = "+num2str(obscuration))	
		//variable thickness=getthickness()
		//print GetDataFolder(0) +("    thickness = "+num2str(thickness))//(obscuration))
end

function LoadMastersizer2000text()
//Loads tab delimited mastersizer files.  Export 1 Experiment per file. If the dispersant is not water then the index of refraction (RI) needs to  be known.
//angle_air,angle_real, and magic were taken from the Mastersizer2000IntesnityAngle.xls file.  It already accounts for the sample RI difference.
//decoded Mastersizer 2000 Intensity Angle.xls,  Mastersizer2000IntensityAngle.xls
//magic is not  known....must be mystical
//q is  calculated with a wavelength of 6328, taken from Schaefer's "DataLoader.ipf" but needs to be verified for the instrument used.
	variable filenum,obscuration,count,flag,RI,pos
	string ,samplename,data,waveheader,q_name,r_name,s_name,nametest
	RI=1.33  //refractive index for water disspersant
	count=0
	samplename="Sample name here"
	waveheader="Sample description"
//folder check and creation if needed
	if (datafolderexists("root:MastersizerData")==0)  
		newdatafolder/s root:MastersizerData
	else
		setdatafolder root:MastersizerData
	endif
//setting calculation parameters taken from Mastersizer2000IntensityAngle.xls   decoded Mastersizer 2000 Intensity Angle
	make /o/n=(44) magic
	magic[0]= {0.0324589,0.0416185,0.0495351,0.058925,0.0701044,0.0833586,0.099062,0.117817,0.140159,0.166591,0.198166,0.235633,0.280381,0.333432,0.396384,0.471365,0.560746,0.667256,0.793754,0.944389,1.122,1.33511,1.59039,1.88926,2.25144,2.68424,3.20147,3.82578,4.59302,5.513,6.64871,8.02366,9.81892,11.8063,14.1611,16.9952,20.6564,24.881,30.1521,36.324,43.825,54.3524,88.928,174.793}
	make /o/n=(44) angle_air
	angle_air[0]= {0.0192201,0.0246372,0.029325,0.0348983,0.0415134,0.0493785,0.0587021,0.0697966,0.0830267,0.0987049,0.117352,0.139593,0.166001,0.197461,0.234859,0.279237,0.332103,0.395022,0.469867,0.558929,0.664914,0.791152,0.941597,1.11947,1.33371,1.59137,1.8984,2.26773,2.71431,3.25818,3.93056,4.76381,5.82093,6.985,8.385,10.06,12.07,14.485,17.385,20.86,25.03,30.035,45,60} 
	make /o/n=(44) angle_real
	angle_real= 180/pi*asin(1/RI*sin(pi/180*angle_air))
	duplicate/o angle_real calculate_q
	calculate_q=(4*pi/6328)*sin(pi*angle_real/180)
	make /o/n=(44) MastersizerIntensity
	open/r/t="????" /M="Select Mastersizer Tab Delimited Export File" filenum //get file
//Read in first data point which is obscuration.  Not used anywhere here but stored in the sample q wave note.
	freadline /t="	" filenum, data  //terminator is a tab
	obscuration=str2num(data)
	do
		freadline /t="	"filenum, data  //terminator is a tab
		MastersizerIntensity[count]=str2num(data)
		count+=1
	while (count<43)
	prompt samplename, "Sample name"//gettting sample name and sample info
	prompt waveheader, "Enter description for the sample."
	doprompt "Sample Name and description", samplename,waveheader
	waveheader+=waveheader+"obscuration: "+num2str(obscuration)
	do
		nametest="q_"+samplename
		if (exists(nametest)==1)
			prompt samplename,"Sample name already exists, choose another name."
			doprompt "Sample Name Correction", samplename
			flag=0
		else 
			flag=1
		endif 
	while(flag==0)//Index of refraction check
	prompt RI, "Enter the refractive index for the dispersant (water): "
	doprompt "Refractive Index", RI
	if (RI!=1.33)
		angle_real= 180/pi*asin(1/RI*sin(pi/180*angle_air))
		calculate_q=(4*pi/6328)*sin(pi*angle_real/180)
	endif
	q_name="q_"+samplename
	duplicate calculate_q $q_name
	Note $q_name, waveheader
	r_name="r_"+samplename
	MastersizerIntensity/=magic//  <<==  <<== MAGIC going on here
	duplicate MastersizerIntensity $r_name
	s_name="s_"+samplename
	MastersizerIntensity*=0.01
	duplicate MastersizerIntensity $s_name
end


Function loadmastersizer2000excel()
	string name,foldername,S_filename,comment
	setdatafolder Root:	
	newdatafolder/s/o temp
	//XLLoadWave/S="Paste Data"/R=(C10,AU14)/Q/O/V=0/K=0/N=w
	//XLLoadWave/S="Paste Data"/R=(A15,A18)/COLT="T"/O/Q/V=0/K=0/N=comments
	foldername=S_filename
		variable npts=strlen(foldername)-5
	foldername=foldername[0,npts]	
	name=AskName(foldername,foldername,28)
	foldername=name
	string rwavename,qwavename,swavename
	rwavename="r"+name;qwavename="q"+name;swavename="s"+name
	Make/o/n=43,$rwavename,$qwavename,$swavename
	wave rw=$rwavename,qw=$qwavename,sw=$swavename
	wave/T comments0
	wave w0,w1,w2,w3,w4,w5,w6,w7,w8,w9,w10,w11,w12,w13,w14,w15,w16,w17,w18,w19,w20,w21,w22,w23,w24,w25,w26,w27,w28,w29,w30,w31,w32,w33,w34,w35,w36,w36,w37,w38,w39,w40,w47,w41,w42,w43,w44
	rw[0,43]={w1[4],w2[4],w3[4],w4[4],w5[4],w6[4],w7[4],w8[4],w9[4],w10[4],w11[4],w12[4],w13[4],w14[4],w15[4],w16[4],w17[4],w18[4],w19[4],w20[4],w21[4],w22[4],w23[4],w24[4],w25[4],w26[4],w27[4],w28[4],w29[4],w30[4],w31[4],w32[4],w33[4],w34[4],w35[4],w36[4],w37[4],w38[4],w39[4],w40[4],w41[4],w42[4],w43[4],w44[4]}
	qw[0,43]={w1[2],w2[2],w3[2],w4[2],w5[2],w6[2],w7[2],w8[2],w9[2],w10[2],w11[2],w12[2],w13[2],w14[2],w15[2],w16[2],w17[2],w18[2],w19[2],w20[2],w21[2],w22[2],w23[2],w24[2],w25[2],w26[2],w27[2],w28[2],w29[2],w30[2],w31[2],w32[2],w33[2],w34[2],w35[2],w36[2],w37[2],w38[2],w39[2],w40[2],w41[2],w42[2],w43[2],w44[2]}
	qw=(4*1.33*pi/6328)*sin(qw*pi/180)
	rw=10^rw
	comment="info="+comments0[0]+","+comments0[1]
	Note rw,comment
	duplicate/o rw,sw
	sw=.01*rw
	variable/g obscuration=W0[0]
	killwaves comments0,w0,w1,w2,w3,w4,w5,w6,w7,w8,w9,w10,w11,w12,w13,w14,w15,w16,w17,w18,w19,w20,w21,w22,w23,w24,w25,w26,w27,w28,w29,w30,w31,w32,w33,w34,w35,w36,w36,w37,w38,w39,w40,w47,w41,w42,w43,w44
	string cmd,winexists=" "
	winexists= winlist(name,";","WIN:1")
	npts=strlen(winexists)-2
	winexists=winexists[0,npts]	
	if(cmpstr(winexists,name)==0)
		cmd="killwindow "+name
		execute (cmd)
	endif
	 cmd="killDataFolder/z root:"+foldername
	execute (cmd)
	execute ("RenameDataFolder root:temp,"+ foldername)
	Display/k=1 rw vs qw as name
	cmd="DoWindow/C "+name
	DoWindow/C $name
	ModifyGraph log=1
	
end

Function LoadMirror()
	load1d(1,2,2,0,2,9,".RED",1)
	silent 1
	variable index=0,Counter,length, refno,uquit
	String/g Filename,fullPath
	String RowsCols,MinMax,RowValues,ColValues
	string/g Root:Packages:P:gfilename
	SVAR filename=Root:Packages:P:gfilename
	SVAR Path=Root:Packages:P:gpath
	fullpath=path+filename
	
	fullpath=fullpath[0,strlen(fullpath)-4]+"SPY"	
		//Open/R/T=".SPY"/m=".Pick .SPY file" refno as filename
	Open/R/Z=2 refno as fullpath		
	Variable err = V_flag		
	if (err != 0)
		DoAlert 0, "2d Data does not exist"
		abort
	endif
		getfilename(s_filename)
		//fullpath=s_filename
		NewPath/O temporarypath Path//temporary path is not a defined string			
		string/g Rownames

		string/g Rownames
		SVAR basename
		string name="i"+basename
				LoadWave/G/M/Q/D/A=RowColsandMaxmin/L={0,0,2,0,0} fullpath
				LoadWave/G/M/Q/D/A=ColNames/L={0,2,1,0,0} fullpath
				//LoadWave/G/M/Q/D/A=$name/L={0,3,1,0,0} fullpath
				FReadLine refNo, RowNames
				FReadLine refNo, RowNames
				FReadLine refNo, RowNames		
		close refno		
		Variable row	
		LoadWave/G/M/Q/D/A=Wave/L={0,4,0,0,0} fullpath//data part
		Duplicate/o wave0,$name
		killwaves wave0
				duplicate/o $name,itemp
				itemp=log(itemp)
				//ilogwave=log($name)
				Display/K=1;AppendImage itemp;DelayUpdate
				ModifyImage Itemp ctab= {*,*,YellowHot,0}
				ModifyGraph width=288,height=288
				TextBox/C/N=text0/A=MT name
end

Function loadSpyglass(qloadall,Filetype)
	variable qloadall
	String Filetype
	Prompt qLoadAll,"Load all data in a Folder?  TEXT only",popup,"All waves in folder (not displayed);User picks waves one at a time (displayed)"
	//doprompt "Input Panel", qloadall
	silent 1
	setdatafolder root:
	variable index=0,Counter,length, refno,uquit
	String/g Filename,fullPath
	String RowsCols,MinMax,RowValues,ColValues
	string/g Root:Packages:P:gfilename
	if (qloadall==2)//load one
		Open/R/T=Filetype/m=".Pick File" refno as filename
		getfilename(s_filename)
		fullpath=s_filename
		SVAR filename=Root:Packages:P:gfilename
		SVAR Path=Root:Packages:P:gpath
		NewPath/O temporarypath Path//temporary path is not a defined string			
	else //load all
		NewPath/O temporarypath 
	endif
	do  //header part
		if(qloadall==1)//loan all
			filename=IndexedFile(temporarypath, index, "TEXT")
				if (strlen(filename)==0)
					Killvariables/a/z;killstrings/a/z
					break  // exit here
			endif
				Open /R/T=FileType/m="Pick File"/P=temporarypath refno as filename
			getfilename(s_filename)
			fullpath=s_filename
		endif
		string/g Rownames
		SVAR name=Root:Packages:P:gfilename
		Name=Name[0,(strlen(Name)-5)]
		name=AskName(Name,"newname",30)
		name="s"+cleanupName(name,0)	
		
		NewdataFolder/O/S $name
		string/g basename=name[1,inf]
		string/g Rownames
		name="i"+name[1,inf]
				LoadWave/G/M/Q/D/A=RowColsandMaxmin/L={0,0,2,0,0} fullpath
				LoadWave/G/M/Q/D/A=ColNames/L={0,2,1,0,0} fullpath
				//LoadWave/G/M/Q/D/A=$name/L={0,3,1,0,0} fullpath
				FReadLine refNo, RowNames
				FReadLine refNo, RowNames
				FReadLine refNo, RowNames		
		close refno		
		Variable row	
		LoadWave/G/M/Q/D/A=Wave/L={0,4,0,0,0} fullpath//data part
		Duplicate/o wave0,$name
		killwaves wave0
		


			if (qloadall==2)
				duplicate/o $name,itemp
				itemp=log(itemp)
				//ilogwave=log($name)
				Display;AppendImage itemp;DelayUpdate
				ModifyImage Itemp ctab= {*,*,YellowHot,0}
				ModifyGraph width=288,height=288
				TextBox/C/N=text0/A=MT name
				break	
			endif
		setdatafolder root:
while(1)
	
end

function/t loadOneLine(LineNumber,filetype)//set nameline  negative if no name in file
	variable LineNumber;string filetype
	Prompt LineNumber, "Line Number"
	Prompt filetype, "File extension (.txt, .SPY)"
	doprompt "Setup Panel",LineNumber,filetype
	
	variable counter=0,refno
	string HeaderText="",LineofNote=""
	Open/R/T=filetype/m="File Containing Information for Wave Note" refno //as filename
		counter=0
		If(!LineNumber==0)
			do
				FReadLine refNo, LineOfNote	
					Counter+=1
			while(Counter<LineNumber)  //last line of header
			Headertext=LineOfNote
		endif
		close refno
		return Headertext
End

Function Load1dLANL_CSV()
	IR1D_InitDataManipulation()
	string filetype=".csv",fullpath,path,filename="temp",samname
	variable refno
	setdatafolder root:
		Open/R/T=filetype/m=filetype refno as filename
		getfilename(s_filename)
		fullpath=s_filename		
		filename=getfilename(s_filename)
		variable N=strlen(filename)
		samname=filename
		filename=cleanupname(filename[0,N-5],0)	
		filename=Getnamechanges(filename)
		string/g basename=filename
	close refno
	string foldername="L" +filename//can add "L+"  if start with a number
		if (!DataFolderExists("root:LANL_LQD"))		
			NewDataFolder/O root:LANL_LQD
		endif
		setdatafolder root:LANL_LQD
		NewDataFolder/O/S $foldername	
		string/g SampleFile=samname
		string/g basename=filename	
		variable/g thickness=getparameter("Enter Thickness in cm for "+filename,.1)
		variable/g  AbsIntMultiplier =21.1  //6mm = 21.1 4mm = 49.1
		NVAR AbsintMultiplier
//Reducing the waves: data in absolue units(dsigma/domega)*(1/Area)
		LoadWave/o/A/J/Q/W/K=1/V={"\t,"," $",0,1}/L={0,1,0,0,0}

		string rwave, qwave, swave, ewave
	
		rwave="r"+filename
		swave="s"+filename
		qwave="q"+filename
		ewave="e"+filename
		Wave Intensity_a_u__
		Wave Q_Angstroem_1_
		Wave STDDEV
		WAVE Q_error
		Intensity_a_u__=AbsintMultiplier*Intensity_a_u__/thickness
		STDDEV=AbsintMultiplier*STDDEV/thickness
		duplicate/o Intensity_a_u__,$rwave
		duplicate/o Q_Angstroem_1_,$qwave
		duplicate/o STDDEV,$swave//STDEV column in raw file
		duplicate/o Q_error, $ewave//RMSBIN column in raw file
		killwaves/z Wave Intensity_a_u__, Q_Angstroem_1_,STDDEV,Q_error,log_Q_,log_intensity_
		
		plotdata(rwave,qwave,filename)		
	
		string/g root:Packages:SASDataModification:IntensityWaveName=rwave	
		string/g root:Packages:SASDataModification:QWavename=qwave	
		string/g root:Packages:SASDataModification:ErrorWaveName	=swave
		string/g root:Packages:SASDataModification:DataFolderName=getdatafolder(1)
		//variable t=thickness
		//variable/g root:Packages:SASDataModification:Data1_Thickness= t
		//variable/g Thickness_Orig=t

		
	end




Function Plotregenerator109()

	variable nop=2, count=0, counter = 0
	string SampleFolder, nameofsample, plot1r, plot1q,plot2r, plot2q,plot3r, plot3q, plotXr, plotXq
	Prompt SampleFolder, "Select  data folder for sample", popup,  IN2G_FindFolderWithWaveTypes("root:", 5, "rzbkg", 1)
	doprompt "Plot Input Panel", SampleFolder
	SetDataFolder SampleFolder
	string foldername = getdatafolder(0)
	nameofsample = foldername[2,100]
	wave pls, b, g, rga, rgb, ma, mb, rs
		
	plot1r= "r_" + nameofsample
	plot1q="q_" + nameofsample
	plot2r = "rpsd_" + nameofsample
	plot2q = "qpsd_" + nameofsample
	plot3r = "rmod_" + nameofsample
	plot3q = "qmod_" + nameofsample
	plotXr= "rp1_" + nameofsample
	plotXq="qp1_" + nameofsample
	Display rzbkg vs qzbkg
	AppendToGraph $plot1r vs $plot1q
	AppendToGraph $plot2r vs $plot2q
	AppendToGraph $plot3r vs $plot3q
	ModifyGraph lstyle($plot2r)=3,rgb($plot2r)=(0,0,0)
	ModifyGraph lsize($plot3r)=2,rgb($plot3r)=(0,0,0)
	ModifyGraph log(left)=1, log(bottom)=1, grid(left)=1, grid(bottom)=2
	Label bottom "\\Z18\\f01q(A\\S-1\\M\\Z18\\f01)"
	Label left "\\Z18\\f01Intensity"
	ModifyGraph mode=0,lsize(rzbkg)=2
	ModifyGraph lsize($plot1r)=2,rgb($plot1r)=(0,0,65280)
	ModifyGraph tick=2, msize=2, lsize=2, mirror(bottom)=1, fSize(left)=12, fSize(bottom)=14, margin(top)=15,margin(right)=15
	Legend/C/N=text3
	
	do //plotting fitting graphs
	if(waveexists($plotXr)!=0)
	AppendToGraph $plotXr vs $plotXq
	ModifyGraph lsize($plotXr)=2,rgb($plotXr)=(0,65280,0)
	plotXr="rp" + num2str(nop) + "_" + nameofsample
	plotXq="qp" + num2str(nop) + "_" + nameofsample
	count+=1
	else
	endif
	nop+=1
	while (nop<11)
	
	nop=1
	
	do
	plotXr="rp" + num2str(nop) + "_" + nameofsample
	Tag $plotXr, 0,"\\Z10P = " + num2str(pls(counter)) + "\rB = " + num2str(b(counter)) + "\rG = " + num2str(g(counter)) + "\rRg = " + num2str(rga(counter)) + " : " + num2str(rgb(counter)) + "\rMean = " + num2str(ma(counter)) + "+/-" + num2str(mb(counter)) + "\rRs = " + num2str(rs(counter))
	counter+=1
	nop+=1
	while(counter < count)
	
end

Function Plotregenerator108()

	variable nop=2, count=0, counter = 0
	string SampleFolder, nameofsample, plot1r, plot1q,plot2r, plot2q,plot3r, plot3q, plotXr, plotXq
	Prompt SampleFolder, "Select  data folder for sample", popup,  IN2G_FindFolderWithWaveTypes("root:", 5, "rzbkg", 1)
	doprompt "Plot Input Panel", SampleFolder
	SetDataFolder SampleFolder
	string foldername = getdatafolder(0)
	nameofsample = foldername[2,100]
	wave pls, b, g, rg, stddevrg, rs
		
	plot1r= "r_" + nameofsample
	plot1q="q_" + nameofsample
	plot2r = "rpsd_" + nameofsample
	plot2q = "qpsd_" + nameofsample
	plot3r = "rmod_" + nameofsample
	plot3q = "qmod_" + nameofsample
	plotXr= "rp1_" + nameofsample
	plotXq="qp1_" + nameofsample
	Display rzbkg vs qzbkg
	AppendToGraph $plot1r vs $plot1q
	AppendToGraph $plot2r vs $plot2q
	AppendToGraph $plot3r vs $plot3q
	ModifyGraph lstyle($plot2r)=3,rgb($plot2r)=(0,0,0)
	ModifyGraph lsize($plot3r)=2,rgb($plot3r)=(0,0,0)
	ModifyGraph log(left)=1, log(bottom)=1, grid(left)=1, grid(bottom)=2
	Label bottom "\\Z18\\f01q(A\\S-1\\M\\Z18\\f01)"
	Label left "\\Z18\\f01Intensity"
	ModifyGraph mode=0,lsize(rzbkg)=2
	ModifyGraph lsize($plot1r)=2,rgb($plot1r)=(0,0,65280)
	ModifyGraph tick=2, msize=2, lsize=2, mirror(bottom)=1, fSize(left)=12, fSize(bottom)=14, margin(top)=15,margin(right)=15
	Legend/C/N=text3
	
	do //plotting fitting graphs
	if(waveexists($plotXr)!=0)
	AppendToGraph $plotXr vs $plotXq
	ModifyGraph lsize($plotXr)=2,rgb($plotXr)=(0,65280,0)
	plotXr="rp" + num2str(nop) + "_" + nameofsample
	plotXq="qp" + num2str(nop) + "_" + nameofsample
	count+=1
	else
	endif
	nop+=1
	while (nop<11)
	
	nop=1
	
	do
	plotXr="rp" + num2str(nop) + "_" + nameofsample
	Tag $plotXr, 0,"\\Z10P = " + num2str(pls(counter)) + "\rB = " + num2str(b(counter)) + "\rG = " + num2str(g(counter)) + "\rRg = " + num2str(rg(counter)) + "\rStdDevRg = " + num2str(stddevrg(counter)) + "\rRs = " + num2str(rs(counter))
	counter+=1
	nop+=1
	while(counter < count)
	
end

Function CleanupMicromeriticsNames()
	if (waveexists(qzbkg))
		duplicate/o qzbkg,qbkg
		duplicate/o rzbkg,rbkg
		killwaves qzbkg,rzbkg
	endif
	string newfolder,foldername=GetDataFolder(0),fullfoldername=GetDataFolder(1),oldwavename,newwavename
	newfolder=foldername
	variable counter1=0
		do//take illegal characters out
		do
			if(cmpstr(foldername[counter1,counter1+4],"_REP_")==0)
				newfolder[counter1,counter1+4]="_"
					DoAlert 2, (foldername+"\rIgor will remove _REP_  in folder and wavenames\rMake sure all graphs are open.\rOK to proceed")
					If(V_Flag==2)
						abort
					endif
					If(V_flag==1)
						RenameDataFolder $fullfoldername,$Newfolder
						oldwavename=foldername
						newwavename=newfolder
						string rwave,qwave, swave,rold,qold,sold
						rwave="r"+newwavename;qwave="q"+newwavename;swave="s"+newwavename
						if (waveexists($rwave))				
							rold="r"+oldwavename;qold="q"+oldwavename;sold="s"+oldwavename
							Rename $rold, $rwave;Rename $qold, $qwave;Rename $sold, $swave
						endif
						
						DoAlert 1, "Wavenames don't match folder names.\rProceed?"
						If (V_flag==2)
							abort
						endif
					endif
				break
			endif
			break
		while(0)
		counter1+=1
	while(counter1<31)
end

Function FixAllFolderAndWaveNames()//working here
	ScanAllFolders("root:", 4,"CleanupMicromeriticsNames()")
end

macro loadMicromeriticsV1_09TXT(qloadall)
	variable qloadall
	variable linelimit
	qloadall=2;linelimit=5000
	Prompt qLoadAll,"Load all data in a Folder?",popup," User picks waves one at a time (Displayed)"
	variable plchecker, good
	silent 1
	setdatafolder root:
	NewDataFolder/O MicromeriticsUC_SN_131
	variable index=0,Counter,length, refno,var,  killcounter, Rgchecker,SdRgchecker, Rschecker
	variable nop
	String LineOfNote,HeaderText,name,rwave,swave,qwave,qmodwave,qpsdwave, rpsdwave,rmodwave,filename,samplename,path,fullpath,qpsdwavename,rpsdwavename,wavenames,qwavename,rwavename,swavename
	String qmodwavename, rmodwavename, qpwavename, rpwavename, qpwave,rpwave, literal
	String parameter, parm
	String/g Root:Packages:P:xvalue, Root:Packages:P:yvalue,Root:Packages:P:gYLabel="\F'arial'\Z18\f01Intensity",Root:Packages:P:gXLabel="\F'arial'\Z18\f01q(\S-1\M\Z18)"
	string adder
	String Xa=Root:Packages:P:xvalue,Ya=Root:Packages:P:yvalue,yLabel=Root:Packages:P:gYLabel,xLabel=Root:Packages:P:gXLabel
	String xaxislabel, yaxislabel
	string/g Root:Packages:P:gfilename
	string rcolortypes="65535;0;0;65535;52428;0;39321;52428;1;26214;65535;0;0;65535;52428;0;39321;52428;1;26214"
	string gcolortypes="0;0;65535;43690;1;0;13101;52425;24548;26214;65535;0;0;65535;52428;0;39321;52428;1;26214"
	string bcolortypes="0;65535;0;0;41942;0;1;1;52428;26214;65535;0;0;65535;52428;0;39321;52428;1;26214"
	variable red=FindString2num(0,rcolortypes,";")
	variable green=FindString2num(0,gcolortypes,";")
	variable blue=FindString2num(0,bcolortypes,";")
	if (qloadall==1)//load one
		Open/R/T="TEXT"/m="Text file only" refno as filename//User picks a file	
		getfilename(s_filename)
		fullpath=s_filename
		filename=Root:Packages:P:gfilename	
		NewPath/O temporarypath Root:Packages:P:gpath//temporary path is not a defined string      	      
	 else //load all pick folder
		NewPath/O temporarypath //User picks a folder, temporary path is not a defined string
	endif
	//do//cycle through all text files in folder
		//if(qloadall==1)//loading all files
		//	filename=IndexedFile(temporarypath, index, ".txt")
			//	if (strlen(filename)==0)//any more files?
			//		Killvariables/a/z;killstrings/a/z
			//		break  //always exit here when files are exhausted
			//	endif
		//	Open /R/T="TEXT"/m="Text file only"/P=temporarypath refno as filename
		//	getfilename(s_filename)
		//fullpath=s_filename
		//endif
	counter=0
	plchecker=0
		HeaderText=filename+"\r"//Header should be put in as a note in intensity data
		do//get the header information
			FReadLine refNo, LineOfNote	
			HeaderText+=LineOfNote
				if (stringmatch(LineofNote, "*Sample*" ))
					samplename=Getnamechanges(lineofnote)//could be cleaned up.  remove sample ID		
					samplename=cleanupName(samplename,0)	
				endif
			Counter+=1
		while(Counter<17)
		length =strlen(filename)//+filename[0,(length-5)]+""
		name="M_"+samplename//may have to eliminate more for .rep.text
		name=cleanupName(name,0)
		name=name[0,28]
		NewDataFolder/O/S $name
		variable/g obscuration, Sample_Concentration
		variable  startline, endline
	do//find goodness of fit and signal fraction
			FReadLine refNo, LineOfNote
			counter=counter+1
 			if (stringmatch(LineofNote, "*Sample Concentration*" ))
				print lineofnote
				print lineofnote[39,46]
				Sample_Concentration=str2num(lineofnote[39,46])			
			endif
 			if (stringmatch(LineofNote, "*obscuration*" ))
				print lineofnote
				print lineofnote[23,27]
				obscuration=str2num(lineofnote[23,27])		
			endif
			If (stringmatch(LineofNote, "*Particle Diameter*" ))//look for mie size distributions
				Print "\r"+(num2str(counter))+" "+lineofnote
				Print "start"
				print counter
				 startline=counter
				do	
					FReadLine refNo, LineOfNote
					counter=counter+1
					If (stringmatch(LineofNote, "\r" ))
						print "end"
						 endline=(1+counter)-startline
						 print endline
						LoadWave/n/g/A=miepsd/k=1/L={0,startline,endline,0,2} fullpath
						//add code to change names to match protocol  r_mie_name_testno and qmie_name_testno
						break
					endif
				while(1)
			endif
			If (stringmatch(LineofNote, "Background Intensity vs. Angle*" ))//load the background waves
				//Print "\r"+(num2str(counter))+" "+lineofnote
				LoadWave/n/A=bkwave/g/k=1/L={0,(counter+4),465,0,2} fullpath
				//make/o qzbkg,rzbkg,szbkg
				duplicate/o bkwave0,qzbkg;duplicate/o bkwave1,rzbkg;duplicate/o bkwave1 szbkg
				szbkg=0.01*szbkg//dummy error wave
				qzbkg=(4*pi*1.33/6580)*sin (qzbkg*pi/360)//assumes water
				killwaves bkwave0, bkwave1
			endif	
			
			//if (counter==linelimit)//exceeded the line limit must not be any more tests
				//DoAlert 0, "Line limit exceeded. No backgrouund found."
				//break
			//endif
			if (stringmatch(LineofNote, "Goodness of Fit*" ))
			//LoadWave/n/g/k=1/L={0,(counter+4),465,0,2} fullpath
				LoadWave/n/g/n=w/k=1/L={0,(counter+2),0,0,2} fullpath//all the rest must be sample waves, load them
				wavenames=s_wavenames
		        endif
		        make/o/t/n=10 linereader
			if(stringmatch(LineofNote,"G*"))//LOADING THE VALUES OF B, G, Rg
				linereader[plchecker] =lineofnote//count the number of G* found.  One more than the number of levels
				plchecker=plchecker+1 
			endif			
	while(counter<linelimit)		//get the unified parameters					
				make/o/N=(plchecker) G, B, PLS, RgA, RgB, MA, MB, Rs
				do
				lineofnote=(linereader[(nop+1)])
				print lineofnote
					G[nop] = (str2num(LineofNote[2,5])*(10^str2num(lineofnote[7,9])))
					B[nop]=(str2num(LineofNote[13,16])*(10^str2num(lineofnote[18,21])))
					PLS[nop]=(str2num(LineofNote[24,27])*(10^str2num(lineofnote[29,31])))
					RgA[nop]=(str2num(LineofNote[37,41]))
					RgB[nop]=(str2num(LineofNote[45,48]))
					MA[nop]=(str2num(LineofNote[58,62]))
					MB[nop]=(str2num(LineofNote[68,72]))
					Rschecker = strsearch(LineofNote,"Rs",0)
					Rs[nop]=str2num(LineofNote[(Rschecker+3),150])										
					nop=nop+1
			while(nop<(plchecker-1))
		//ASSIGNING THE PROPER NAMES TO THE LOADED WAVES
		name= name[1,28]
		       rwave="r"+name
			qwave="q"+name
			swave="s"+name
			qmodwave="qmod"+name
			rmodwave="rmod"+name
			qpsdwave="qpsd"+name
			rpsdwave="rpsd"+name
			//make/o $qwave,$rwave,$swave,$qmodwave,$rmodwave,$qpsdwave,$rpsdwave
						
			qwavename= stringfromlist((0),wavenames)
			rwavename=stringfromlist((1),wavenames)
			qmodwavename=stringfromlist((2),wavenames)
			rmodwavename=stringfromlist((3),wavenames)
			qpsdwavename=stringfromlist((4),wavenames)
			rpsdwavename=stringfromlist((5),wavenames)
					
			duplicate/o  $qwavename,$qwave
			duplicate/o  $rwavename,$rwave
			duplicate/o  $rwavename,$swave
			$swave*=.01
			duplicate/o  $qmodwavename,$qmodwave
			duplicate/o  $rmodwavename,$rmodwave
			duplicate/o  $qpsdwavename,$qpsdwave
			duplicate/o  $rpsdwavename,$rpsdwave
			
		Xa=qwave
		Ya=rwave
		Root:Packages:P:xvalue=Xa; Root:Packages:P:yvalue=Ya
		Display $Ya vs $Xa
		ModifyGraph log=1, tick=2,axThick=2,msize=2,mrkThick=3, mode=3,marker=19
		Legend/C/N=added2/J/A=MC"\\s('"+Ya+"')"+ya
	      Xa=qmodwave
		Ya=rmodwave
		Root:Packages:P:xvalue=Xa; Root:Packages:P:yvalue=Ya
	      Append $Ya vs $Xa
		//Legend/C/N=added2/J/A=MC"\\s('"+Ya+"')"+ya
		Modify log(bottom) =1
		Modify log(left)=1
		 ModifyGraph log=1, tick=2,axThick=2,msize=3,mrkThick=5, mode($Ya)=0,rgb($Ya)=(500,500,500),lSize=2, lStyle=0
		Xa=qpsdwave
		Ya=rpsdwave
		 Append $Ya vs $Xa
		ModifyGraph log=1, tick=2,axThick=2,msize=3,mrkThick=5, mode($Ya)=0,rgb($Ya)=(8000,500,500),lSize=2, lStyle($Ya)=3
	makemeasuredwave()//not debugged written by Ryan and DWS		
			//ASSIGNING NAMES TO THE POWER LAW REGIMES 
	nop = 0
	do		
		adder = num2str(nop+1)
		//print adder
		rpwave="rp"+adder+name
		qpwave="qp"+adder+name
		//make/o $rpwave $qpwave
		qpwavename= stringfromlist((6+(nop*2)),wavenames)
		rpwavename=stringfromlist((7+(nop*2)),wavenames)
		duplicate/o  $qpwavename,$qpwave
		duplicate/o  $rpwavename,$rpwave			
		Xa=qpwave
	       Ya=rpwave
	       Append $Ya vs $Xa
		red=FindString2num((nop+1),rcolortypes,";")
		green=FindString2num((nop+1),gcolortypes,";")
		blue=FindString2num((nop+1),bcolortypes,";")	      
		ModifyGraph  log=1, tick=2,axThick=2,msize($Ya)=3,mrkThick=2, mode($Ya)=0,marker=19, rgb($Ya)=(red, green, blue), lSize($Ya)=2, lStyle($Ya)=0
		literal="P = "+num2str(PLS[nop]) +"\rB = "+num2str(B[nop]) +"\rG = "+num2str(G[nop])+"\rRg= "+num2str(RgA[nop])+" : "+num2str(RgB[nop])+"\rMean = "+num2str(MA[nop])+ "+/-" + num2str(MB[nop])+"\rRs = "+num2str(Rs[nop])
		Tag $Ya,0,literal///L=0  
		//ChangetoLineandPoints(1,1)
		nop =nop +1		
	while(nop<(plchecker-1))				
		//if (Qloadall==1)
			//dowindow/k Graph0
		//endif
		//index=index+1	
	Modify grid=2,tick=2,minor=1,font="Times",zero(left)=1,standoff=0, mirror=1;DelayUpdate	 
	xaxislabel="\F'times new roman'\Z18\f01"+xlabel
	yaxislabel="\F'times new roman'\Z18\f01"+ylabel
	Label bottom xaxislabel;
	Label left yaxislabel;	
	ShowInfo;ShowTools		
	close refno
	killwaves/z w0, w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w10, w11, w12, w13, w14, w15, linereader
	Newdatafolder /O/S Fitting_Parameters
	LoadWave/A = S_filename/J/D/ n=W/K=0/L= {0,0,0,0,2}S_filename//max put filename in
	rename W0 value
	rename W1 varname					
	setdatafolder root:		
		//while(qloadall==1)//don't recycle for single folder option
	if (qloadall==1)
	 	LoadMicromeriticsV1_09TXT(1)//allow user to hand pick another file
	endif	
	end


//load1d(0,2,4,-1,36,2,".dat",1)   load1d(0,2,4,-1,36,2,".dat",0)
//load1d(0,2,4,-1,0,2,".txt",0)

function load1d(newfolder,qdisplay,nm,nameline,headerlines,nocols,filetype,dialog)
	variable qdisplay,nm, nameline,headerlines,nocols,newfolder,dialog
	string filetype
	//filetype=".dsm";headerlines=7;nocols=4;newfolder=1;nameline=2  ////NIST USANS
	Prompt qdisplay,"Plot?",popup,"No Plot;Plot"
	prompt nm,"Column 2?",popup,"nm;Angstroms;degrees(theta/2);degrees(theta)"
	prompt newfolder,"Create New  Folder?",popup,"Yes;No"
	Prompt nameline,"Line containg sample name"
	Prompt headerlines,"Number of Lines in Header"
	prompt nocols,"Number of Columns of Data"
	prompt filetype, "Extension or mac file type"
	if(dialog)
		doprompt "Input Panel", qdisplay,nm,newfolder,nameline,headerlines,nocols,filetype
	endif
	silent 1	
	Execute "Pfolder()"
	
	//NewDataFolder/O PutSourceNameHere
	variable index=0,Counter,length, refno,len,endname
	String LineOfNote,HeaderText,name,rwave,swave,qwave,ewave,fwave,wwave,samplename="",fullpath
	string/g Root:Packages:P:gfilename="tempfile"
	SVAR filename=Root:Packages:P:gfilename
	
	string/g Root:Packages:P:gpath
	SVAR path=Root:Packages:P:gpath
			Open/R/T=filetype/m=filetype refno as filename
			getfilename(s_filename)
			fullpath=s_filename
			
			NewPath/O temporarypath path//temporary path is not a defined string

		counter=0//put initial lines in notes are of wave
		HeaderText=filename+"\r\r"
		If(!headerlines==0)
			do
				FReadLine refNo, LineOfNote;abortonRTE
				HeaderText+=LineOfNote
					if (counter ==nameline)//picks sample name out of this line
						length =strlen(lineofnote)
						samplename=lineOfNote[15, (length-3)]				
					endif	
					Counter+=1
			while(Counter<headerlines)  //last line of header
		endif
			close refno;abortonRTE
		name=filename
		len=-1+strlen(name)//strip .xxx
		endname=len-strlen(filetype)
		name=name[0,endname]//may need to redefine for non .txt files
		
		if (!stringmatch(samplename,"")==1)
			name=samplename//+="_"+samplename
		endif
		//name="R"+name//+"_"+filetype[1,3]
		//name=cleanupName(name,0)
		name=Getnamechanges(name)
		//name=cleanupName(name,0)
		string foldername="R"+name[0,30]
		if (newfolder==1)
			setdatafolder root:
			NewDataFolder/O/S $foldername//****************** changed 2012 09 20  DWS	
		endif
		string/g basename
			SVAR basename
			basename=name[0,31]
		LoadWave/q/a/O/g/L={0,counter,0,0,nocols} fullpath//*******************
		qwave="q"+basename
		rwave="r"+basename
		swave="s"+basename
		wwave="w"+basename
		fwave="f"+basename//fit
	
		If (!WaveExists(wave2))
			duplicate wave0, wave2
		endif
		If (!WaveExists(wave3))
			duplicate wave0, wave3
		endif
		If (!WaveExists(wave4))
			duplicate wave0, wave4
		endif
		wave wave0,wave1,wave2,wave3,wave4
		Sort wave0,wave0,wave1,wave2,wave3,wave4
		
		variable i
		for (i=numpnts(wave1);i>=0;i-=1)//zap zeros and negatives
			if ((wave1[i] <= 0)||(wave2[i] <= 0))
				Deletepoints i, 1, wave0,wave1,wave2,wave3,wave4
			endif	
		endfor
		duplicate/o wave0,$qwave
		duplicate/o wave1,$rwave
		
		if((nocols==4)&&(1==StringMatch(filetype, ".dat" )))      //4 for SPEAR Data or NIST USANS  Assuming you have to take the sq root
			     //wave3 is variance in q   FOR SPEAR		 and Asterix
				wave2=sqrt(wave2);wave3=sqrt(wave3);duplicate/o wave2,$swave   //SPEAR
				doalert 0, "LANL SPEAR and ASTERIX only"
			ewave="w"+basename
			
		 elseif((nocols==5)&&(StringMatch(filetype, ".fit" )))//asterix fits
			wave3=sqrt(wave3)
			wave4=sqrt(wave4)
			duplicate/o wave2,$rwave
			duplicate/o wave3,$swave
			duplicate/o wave4,$wwave
			duplicate/o wave1,$fwave
			doalert 0, "Asterix  .fit file Only"
			
		elseif((nocols==4)&&(StringMatch(filetype, ".txt" )))  //ornl LR
			duplicate/o wave2,$swave
			duplicate/o wave3,$wwave
			doalert 0, "ONRL LR Only"
		else
			if(nocols>=3)
				duplicate/o wave2,$swave
				killwaves wave2
			endif
		endif
		wave q=$qwave
		
		if(nm==3)
			q = (4*pi/1.54)*sin(q*pi/180)
		elseif(nm==4)//rigaku .dat
			//q = (4*pi/1.54)*sin(q*pi/(2*180))//change from angle to q
		else
			q=q/(1+9*(nm==1))	//abs($qwave/10)
		endif
		
		Note $rwave HeaderText
		string/g Header=HeaderText
		killwaves/z wave0,wave1,wave2,wave3,wave4, wave5, wave6, wave7, wave8, wave9
		string/g root:Packages:ReflectivityTool:Rwave

		SVAR RWaveName=root:Packages:ReflectivityTool:Rwave
		
			if (qdisplay==2)
				dowindow/K ImportGraph
				Display/N=ImportGraph/K=1/W=(20*IN2G_ScreenWidthHeight("width"),5*IN2G_ScreenWidthHeight("heigth"),50*IN2G_ScreenWidthHeight("width"),40*IN2G_ScreenWidthHeight("height")) $rwave vs $qwave
				ControlBar /T 60
				ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
				TextBox/C/N=text0/A=MC name
				ControlBar /T 60
				Button AverageCursors,pos={0,20},size={80,16},font="Times New Roman",fSize=10,proc= DWS_ReflButtonProc,title="AveCsrs"//, win=import
				Button Deletept title="delete point",size={100,16},fSize=10;DelayUpdate
				Button Deletept proc=DWS_ReflButtonProc,font="Times New Roman";DelayUpdate
				cursor/P a,$rwave,0
				cursor/P b,$rwave,4
				Label bottom "q(\\S-1\\M)"
				DWS_AttachErrorBars(1)
			endif
		//index=index+1
	close/A
end


function shiftprofile()
	String Wait2FitGrfName = winname(0,1)
		showinfo
		NewPanel/K=1 /W=(300,500,700,600) as "Move Cursor"
		DoWindow/C PauseforCursers		//Set a Name to Panel
		AutoPositionWindow/E/M=1/R=$Wait2FitGrfName	//Put panel near the graph
		DrawText 21,20,"Put cursor A at the preferred zero point"
		PauseForUser PauseforCursers, $Wait2FitGrfName
		string rwave= CsrWave(A)
		string folderpath =getwavesDataFolder(TraceNameToWaveRef("", rwave),1)
		//string datafolder=getwavesdatafolder ($rwave,1)
		setdatafolder folderpath
			string xwave="q"+rwave[1,100]
			string xnew=xwave+"_shift"
			wave x=$xwave		
			duplicate/o x, $xnew
			wave xn=$xnew
			print xcsr(a)
			xn=-(x-x[xcsr(a)])
			AppendToGraph $rwave vs xn
			RemoveFromGraph $rwave	
end

function ShiftIlavskyProfile()
		setdatafolder root:Packages:Refl_SimpleTool
		variable firstx= pnt2x(SLDprofile, 0 )
		variable Npts=numpnts(sldprofile )
		variable lastx=pnt2x(SLDprofile, Npts)
		variable dx =-(lastx-firstx)/Npts
		variable top =pnt2x(SLDprofile, Npts)
		SetScale/P x top,dx,"", SLDProfile	
END

function LoadParratt_SLD(newfolder)
	variable newfolder
	prompt newfolder, "New Folder?", Popup, "Yes;No"
	//load1d(1,2,2,10000,0,3,".dat")
	load1d(newfolder,2,2,10000,0,3,".dat",1)
	doupdate
	load1d(2,2,2,10000,0,2,".pro",1)
	ModifyGraph log=0
	showinfo
	SVAR basename
	string temp="r"+basename
	Cursor A, $temp,1
	ModifyGraph rgb=(0,0,0)
	ModifyGraph mode=0
	DoUpdate
	shiftprofile()
	//(newfolder,qloadall,nm,nameline,headerlines,nocols,filetype)
	variable refno
	Open /R/T=".par"/P=temporarypath refno 
	LoadWave/Q/J/K=2/A/O/N=waven s_filename
	string name= s_filename
	variable endname
	endname=strlen(name)-5
	name=name[0,endname]//may need to redefine for non .txt files
	 name=name+"_par"
	duplicate/o waven0,$name
	killwaves/z waven0
end



function Spec_Importer(Specrun)//***************
	variable specrun
		
	variable counter,refNo,len,endname,starthead=1e10,endhead=1e10,lastdata=1e10,underbar
	string LineOfNote,samplename, HeaderText="",filetype=".txt",name,spec
	//NewPath /M="Select path to data to be imported" /O ImportDataPath
	killwaves/z stopwave
	Wave/T WaveOfFiles  = root:Packages:ImportData:WaveOfFiles
	Wave WaveOfSelections = root:Packages:ImportData:WaveOfSelections
	variable i, imax, firstSelectedPoint, maxWaves
	make/N=5 stopwave=1
	string SelectedFile
	imax = numpnts(WaveOfSelections)
	firstSelectedPoint = NaN
	For(i=0;i<numpnts(WaveOfSelections);i+=1)
		if(WaveOfSelections[i]==1)
			firstSelectedPoint = i
			break
		endif
	endfor
	if (numtype(firstSelectedPoint)==2)
		abort
	endif
	selectedfile = WaveOfFiles[firstSelectedPoint]
	SVAR DataPathName=root:Packages:ImportData:DataPathName
	string openfilename=DataPathName+selectedfile 
	variable nameline=1	
	Open/R refno as openfilename
	name=getfilename(s_filename)
	len=-1+strlen(name)
	endname=len-strlen(filetype)
	name=name[0,endname]//may need to redefine for non .txt files
		if (!stringmatch(name,"")==1)
			name="R"+num2str(specrun)+"_"+name
			name=cleanupName(name,0)
			name=name[0,30]
		endif		
	HeaderText=name+"\r\r"	
	spec= "#S "+num2str(specrun)	
		do
			FReadLine refNo, LineOfNote			
			if (strsearch(lineofnote, spec, 0 )!=-1)
				starthead=counter
			endif
			if ((strsearch(lineofnote, "#L", 0 )!=-1)&&(Counter>starthead))
				endhead = counter
			endif
			If((counter>=starthead)&&(counter<=endhead))
				HeaderText+=LineOfNote					
			endif			
			Counter+=1
		while(Counter<endhead)  //last line of header	
	do
		FReadLine refNo, LineOfNote	
		if (stringmatch(LineOfNote, ""))
			Lastdata=counter
			break
		endif	
		Counter+=1
		stopwave[p]=stopwave[p-1]
		If (stringmatch(lineofnote,""))
			stopwave[4]=0
		else
		stopwave[4]=1
		endif//look for 5 blank lines		
	while ((Counter < lastdata)&&(sum(stopwave)!=0))
	
	endhead =endhead +1
	variable	numlines=lastdata-endhead
	setdatafolder root:
	string foldername=name
	NewDataFolder/O/S $foldername
	string/g basename=name[1,inf]

	LoadWave/q/a/D/g/P=importdatapath /L={0,endhead,numlines,0,20} s_filename//*******************
	string rwavenm, swavenm,qwavenm,awavenm
	rwavenm="r"+basename
	swavenm="s"+basename
	qwavenm="q"+basename
	awavenm="a"+basename
	NVAR wavelength=root:Packages:ImportData:wavelength
	wave wave0,wave1,wave2,wave3,wave4,wave5,wave6,wave7,wave8,wave9,wave10	,wave11,wave12,wave13,wave14,wave15,wave16,wave17,wave18,wave19,wave20
	duplicate/o wave0, $qwavenm
	duplicate/o wave0,  $awavenm//angle wave
	
	SVAR scanpick=root:Packages:ImportData:scanpick
		if (stringmatch (scanpick,"All"))
			Doalert 0, "No code for importing this selection"
		elseif (stringmatch (scanpick,"a2scan"))
			duplicate/o wave15,$rwavenm,$swavenm//ID12_C  reflectivity scan
			wave rwave=$rwavenm
			rwave/=wave14//normalize by monitor counts
		else
			duplicate/o wave9,$rwavenm,$swavenm//CHESS sample theta
			wave rwave=$rwavenm
			rwave/=wave8//normalize by monitor counts
		endif
		wave qwave=$qwavenm;wave swave=$swavenm;wave awave=$awavenm
		qwave = (4*pi/wavelength)*sin(awave*pi/180)     //lambda=12.3908/E	
		swave = swave/.01//junk s wave  Delta E = 1.5%,  delta angle = 1mm/13000  for CHESS
	killwaves wave0,wave1,wave2,wave3,wave4,wave5,wave6,wave7,wave8,wave9,wave10	,wave11,wave12,wave13,wave14,wave15,wave16,wave17,wave18,wave19,wave20
	Note $rwavenm HeaderText
	string windowname="W"+basename
	dowindow/K $windowname
	Display/K=1/N=$windowname/W=(400,50,900 ,500) $rwavenm vs $awavenm as basename
	ControlBar /T 30
	Button accept,pos={5,5},size={50,20},font="Times New Roman",fSize=10,proc=Spec_ButtonProc,title="Accept"
	Button cancel,pos={90,5},size={50,20},font="Times New Roman",fSize=10,proc=Spec_ButtonProc,title="Cancel"
	ModifyGraph log=1
	TextBox/C/N=text0/A=MC basename
	Label left "Reflectivity";DelayUpdate
	Label bottom "Angle ()"
	SetAxis bottom 0.1,0.8 	
	wavestats/Q $rwavenm
	Cursor/P A,$rwavenm V_maxloc		
end

Function SPEC_UpdateListOfFilesScans ()
	Wave/T WaveOfRuns      = root:Packages:ImportData:WaveOfRuns
	Wave WaveOfSelectedRuns = root:Packages:ImportData:WaveOfSelectedRuns
	variable imax = numpnts(WaveOfSelectedRuns)
	variable firstSelectedPoint = NaN,i
	For(i=0;i<numpnts(WaveOfSelectedRuns);i+=1)
		if(WaveOfSelectedRuns[i]==1)
			firstSelectedPoint = i
			break
		endif
	endfor
	if (numtype(firstSelectedPoint)==2)
		abort
	endif
	string selectedfile = WaveOfRuns[firstSelectedPoint]
end


Function Spec_ButtonProc(ctrlName) : ButtonControl
	String ctrlName
	if(cmpstr(ctrlName,"SelectDataPath")==0)
		IR1I_SelectDataPath()	
		IR1I_UpdateListOfFilesInWvs()
		wave/T waveofruns=root:Packages:ImportData:waveofruns
		waveofruns=""
	endif
	if(cmpstr(ctrlName,"updatefiles")==0)
		IR1I_UpdateListOfFilesInWvs()
		wave/T waveofruns=root:Packages:ImportData:waveofruns
		waveofruns=""
	endif
	
	if(cmpstr(ctrlName,"Preview")==0)
		IR1I_TestImportNotebook()
	endif
	
	if(cmpstr(ctrlName,"ImportData")==0)
		NVAR specrun=root:Packages:ImportData:Specrun
		Wave WaveOfSelectedRuns=root:Packages:ImportData:WaveOfSelectedRuns
		Wave WaveOfSPECRuns=root:Packages:ImportData:WaveOfSPECRuns
		variable i, imax,sumofelements
		sumofelements=sum(WaveOfSelectedRuns)
		
		imax= numpnts(WaveOfSelectedRuns )
		for (i=0;i<imax;i+=1)
			if(WaveOfSelectedRuns[i] !=0)
				specrun=WaveOfSPECRuns[i]
				Spec_Importer(specrun)		
				If ((sumofelements!=1)&&(i<sumofelements))
					String Wait2FitGrfName = winname(0,1)
					showinfo
					NewPanel/K=1 /W=(300,500,500,550) as "PAUSE FOR USER"
					DoWindow/C PauseWindow		//Set a Name to Panel
					AutoPositionWindow/E/M=1/R=$Wait2FitGrfName	//Put panel near the graph
					DrawText 21,20,"Kill this window to proceed"
					PauseForUser PauseWindow, $Wait2FitGrfName
				endif
			endif
			
		endfor
	
	endif
	if(cmpstr(ctrlName,"Scan")==0)
		Spec_Scan()	
	endif
	if((cmpstr(ctrlName,"Accept")==0)||(cmpstr(ctrlName,"cancel")==0))
		string Windowname= stringfromlist(0, WinList("w*", ";", "WIN:1" ))
		string  basename=windowname[1,100]
		string DF="Root:R"+basename ,rwavenm="R"+basename
		wave rwave=$rwavenm			
		string oldbasename=basename
		if(cmpstr(ctrlName,"Accept")==0)
			WaveStats/Q rwave
			variable maxy= rwave[pcsr(A)]
			rwave=rwave/maxy		
			button Accept, disable = 1, win=$windowname
			button cancel, disable = 1, win=$windowname
			string oldawavenm="a"+basename,oldqwavenm="q"+basename,oldswavenm="s"+basename,oldrwavenm="r"+basename
			basename=Getnamechanges(basename)
			//basename=cleanupName(basename,0)  //adds an x if it starts with a number
			basename=basename[0,30]	
			string awavenm="a"+basename,qwavenm="q"+basename,swavenm="s"+basename;rwavenm="r"+basename
			If(!stringmatch(oldbasename,basename))
				string olddatfolder="Root:R"+oldbasename
				IF (datafolderexists("root:R"+basename))
					Doalert 0, "That name is taken.\rRe-import"
					dowindow/K $windowname
					DF=getdatafolder(1)
					killdatafolder $DF
				else
				
					RenameDataFolder $olddatfolder, $rwavenm
					rename  $oldawavenm, $awavenm
					rename $oldrwavenm, $rwavenm
					rename  $oldswavenm, $swavenm
					rename  $oldqwavenm, $qwavenm
				endif
			endif
			killwaves/z stopwave
		endif	
		if(cmpstr(ctrlName,"cancel")==0)	
			dowindow/K $windowname
		
			killdatafolder $DF
		endif
	endif
End

function/t loadHeader(nameline,headerlines,filetype)//set nameline  negative if no name in file
	variable nameline,headerlines;string filetype
	Prompt nameline,"line containing sample name"
	Prompt headerlines, "Total lines in Header"
	Prompt filetype, "File extension"
	doprompt "Setup Panel",nameline,headerlines,filetype	
	variable counter,refNo,length,len,endname
	string/g HeaderText=""
	//make HeaderWave
	string filename,LineOfNote,SampleName=""
	string/g name, oldline
	
	Open/R/T=filetype/m="File Containing Information for Wave Note" refno //as filename
	//fullpath=s_filename
	filename=getfilename(s_filename)
	//NewPath/O temporarypath Root:Packages:P:gpath//temporary path is not a defined string	
		counter=0//put initial lines in notes are of wave
		HeaderText=filename+"\r\r"
		If(!headerlines==0)
			do
				FReadLine refNo, LineOfNote
				HeaderText+=LineOfNote
					if (counter ==nameline)//picks sample name out of this line
						length =strlen(lineofnote)
						samplename=lineOfNote[7, (length-2)]				
					endif	
					
					if (stringmatch(lineofnote,"")==1)
						print oldline//linebefore the first blank line
						abort
					endif
					oldline=lineofnote
					Counter+=1
			while(Counter<headerlines)  //last line of header
		endif
		close refno
		name=filename
		len=-1+strlen(name)
		endname=len-strlen(filetype)
		name=name[0,endname]//may need to redefine for non .txt files
		if (!stringmatch(samplename,"")==1)
			name+="_"+samplename
			name=cleanupName(name,0)
			name=Getnamechanges(name)
			name=cleanupName(name,0)
			name=name[0,30]
		endif
		return HeaderText
end

Function SPEC_ImportPanilInitialize()
	//IR1_KillGraphsAndPanels()
	IN2G_CheckScreenSize("height",620)
	DoWindow IR1I_ImportData
	if(V_Flag)
		DoWIndow/K IR1I_ImportData
	endif
	IR1I_InitializeImportData()
	string/g scantypes,scanpick="ascan  samth,a2scan"
	SVAR scantypes
	scantypes="All;Theta;a2scan;"
	string/g specruns="0"
	Variable/g specrun=0,Wavelength=1.033,XRayEnergy//A and KV
	Make/O/T/N=1000 WaveOfRuns
	Make/O/N=1000 WaveofSelectedRuns
	Make/O/N=1000 WaveOfSPECRuns
	Execute("SPEC_ImportPanel()")
end


Window SPEC_ImportPanel() : Panel
	PauseUpdate; Silent 1		// building window...
	dowindow/K specimport
	NewPanel /K=1/N=specimport /W=(3,40,430,660) as "Import data"
	SetDrawLayer UserBack
	SetDrawEnv fsize= 18,fstyle= 1,textrgb= (16384,16384,65280)
	DrawText 84,31,"Import Data in Igor"
	SetDrawEnv linethick= 2,linefgc= (16384,16384,65280)
	DrawLine 21,44,363,44
	DrawText 41,120,"List of available files"
	DrawText 41,395,"Pick multiple runs to import"
	
	Button SelectDataPath,pos={99,53},size={130,20},font="Times New Roman",fSize=10,proc=Spec_ButtonProc,title="Select data path"
	
	SetVariable DataPathString,pos={2,85},size={415,19},title="Data path :", noedit=1
	SetVariable DataPathString,fSize=12,limits={-Inf,Inf,0},value= root:Packages:ImportData:DataPathName
	SetVariable DataExtensionString,pos={220,110},size={150,19},proc=IR1I_SetVarProc,title="Data extension:"
	SetVariable DataExtensionString,fSize=12
	SetVariable DataExtensionString,value= root:Packages:ImportData:DataExtension

	PopupMenu scantypes,pos={310,220},size={170,21},proc=spec_popupControl,title="scan type:"
//	PopupMenu scantypes,mode=2,value=root:Packages:ImportData:scantypes
	PopupMenu scantypes,value=root:Packages:ImportData:scantypes
	
	//PopupMenu scannum,pos={310,255},size={170,21},proc=spec_popupControl,title="run#:"
	//PopupMenu scannum,mode=2,value=root:Packages:ImportData:specruns
	
	ListBox ListOfAvailableData,pos={7,125},size={200,250}
	ListBox ListOfAvailableData,listWave=root:Packages:ImportData:WaveOfFiles
	ListBox ListOfAvailableData,selWave=root:Packages:ImportData:WaveOfSelections
	ListBox ListOfAvailableData,mode= 4
	
	ListBox ListOfRuns,pos={7,400},size={250,210}
	ListBox ListOfRuns,listWave=root:Packages:ImportData:WaveofRuns
	ListBox ListOfRuns,selWave=root:Packages:ImportData:WaveofSelectedRuns
	ListBox ListOfRuns,mode= 4
	
	SetVariable XrayEnergy,pos={220,300},size={162,16},proc=Spec_SetVarProc,title="X-ray energy [keV]"
	SetVariable XrayEnergy,limits={0,Inf,0.1},value= root:Packages:ImportData:XrayEnergy
	
	SetVariable Wavelength,pos={220,270},size={162,16},proc=Spec_SetVarProc,title="Wavelength [A]  "
	SetVariable Wavelength,limits={0,Inf,0.1},value= root:Packages:ImportData:Wavelength
	
	Button updatefiles,pos={210,150},size={90,30},font="Times New Roman",fSize=14,proc=Spec_ButtonProc,title="Refresh"
	Button Preview,pos={210,190},size={90,20},font="Times New Roman",fSize=14,proc=Spec_ButtonProc,title="Preview"
	Button Scan,pos={210,220},size={90,20},font="Times New Roman",fSize=14,proc=Spec_ButtonProc,title="Scan Headers"	
	Button ImportData,pos={300,450},size={90,30},font="Times New Roman",fSize=14,proc=Spec_ButtonProc,title="Import"

EndMacro
Function Spec_SetVarProc(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName
	if(cmpstr("XrayEnergy",ctrlName)==0)
		NVAR Wavelength= root:Packages:ImportData:Wavelength
		Wavelength = 12.3908/VarNum
	endif
	if(cmpstr("Wavelength",ctrlName)==0)
		NVAR XrayEnergy= root:Packages:ImportData:XrayEnergy
		XrayEnergy = 12.3908/VarNum
	endif
	
end	
Function Spec_popupControl(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum
	String popStr
	
	if (cmpstr(ctrlName,"scantypes")==0)
		SVAR scanpick=root:Packages:ImportData:scanpick
		if (stringmatch (popstr,"All"))
			scanpick="#S"
		elseif (stringmatch (popstr,"a2scan"))
			scanpick="a2scan"
		else
			scanpick="ascan  samth"
		endif
	endif
	
	if (cmpstr(ctrlName,"scannum")==0)
		NVAR specrun=root:Packages:ImportData:specrun
		specrun=str2num( popStr)
	endif
end




Function Spec_Scan()
	Wave/T WaveOfFiles      = root:Packages:ImportData:WaveOfFiles
	Wave WaveOfSelections = root:Packages:ImportData:WaveOfSelections
	variable i, imax, firstSelectedPoint, maxWaves
	string SelectedFile
	imax = numpnts(WaveOfSelections)
	firstSelectedPoint = NaN
	For(i=0;i<numpnts(WaveOfSelections);i+=1)
		if(WaveOfSelections[i]==1)
			firstSelectedPoint = i
			break
		endif
	endfor
	if (numtype(firstSelectedPoint)==2)
		abort
	endif
	make/n=1/o stopwave=1
	selectedfile = WaveOfFiles[firstSelectedPoint]
	SVAR DataPathName=root:Packages:ImportData:DataPathName
	string openfilename=DataPathName+selectedfile 
	variable nameline=1;string filetype//3000 line max
	variable counter,refNo,length,len,endname,run,numrun
	string/g HeaderText=""
	string filename,LineOfNote,SampleName="",Name
	Open/R refno as openfilename
	filename=getfilename(s_filename)	
	SVAR scanpick=root:Packages:ImportData:scanpick
		counter=0;numrun=0
		Wave/T WaveOfRuns=root:Packages:ImportData:WaveOfRuns
		Wave WaveOfSelectedRuns=root:Packages:ImportData:WaveOfSelectedRuns
		Wave WaveOfSPECRuns=root:Packages:ImportData:WaveOfSPECRuns
		WaveofRuns=""
		//Redimension/N=200 WaveOfRuns
		//Redimension/N=200 WaveOfSelectedRuns
		//Redimension/N=200 WaveOfSPECRuns
		HeaderText=filename+"\r\r"
		SVAR specruns=root:Packages:ImportData:specruns
		specruns=""
	
			do
				FReadLine refNo, LineOfNote			
					if (counter ==nameline)//picks sample name out of this line
						length =strlen(lineofnote)
						samplename=lineOfNote//[7, (length-2)]				
					endif	
					if (strsearch(lineofnote, scanpick,0)!=-1)//Change to "#S" to fina all scans
						variable last=strlen(lineofnote)-2
						lineofnote=lineofnote[0, last]
						specruns+=lineofnote[3,5]+";"
						WaveOfSPECRuns[numrun]=str2num(lineofnote[3,5])//up to 999
						HeaderText+=LineOfNote+"\r"
						WaveOfRuns[numrun]= lineofnote[2,inf]
						
						numrun+=1
					endif
					counter+=1				
					stopwave[p]=stopwave[p-1]
					If (stringmatch(lineofnote,""))
						stopwave[4]=0
					else
						stopwave[4]=1
					endif//look for 5 blank lines				
				//print num2str(counter)+"   "   +lineofnote			
			while((sum(stopwave)!=0) )
			
			If( numrun==0)
				Waveofruns[0]="No runs of type selected"
				numrun=1

			//Redimension/N=(numrun) WaveOfRuns//dws changed at 12ID
			//Redimension/N=(numrun) WaveOfSelectedRuns
			//Redimension/N=(numrun) WaveOfSPECRuns
		endif
		close refno
		killwaves stopwave
		//DoWindow /K parameters
		//NewNotebook/F=1/K=1/N=parameters as "HeaderNotebook"
		//notebook parameters margins={0,1,10000}
		//string cols="Path = "+Samplename[3,inf]
		//notebook parameters, text=cols	
		//notebook parameters,text=HeaderTEXT
		//SaveNotebook/M="Save Parameters notebook" /I/s=6 parameters as "Parameters"
		//print headerText
		
end





Function CursorWait(ywavename,AC,BC)
		string ywavename
		variable AC,BC

		String Wait2FitGrfName = winname(0,1)
		showinfo
		NewPanel/K=1 /W=(300,500,700,600) as "Move Cursor"
		DoWindow/C PauseforCursers		//Set a Name to Panel
		AutoPositionWindow/E/M=1/R=$Wait2FitGrfName	//Put panel near the graph
		DrawText 21,20,"Move cursors and close box"
		Cursor/P A,$ywavename, AC
		Cursor/P B, $ywavename,BC //numpnts($ywavename)-1
		PauseForUser PauseforCursers, $Wait2FitGrfName
		
end
	



function loadUDF_Panalytical(qloadall,Q_ref)
	variable qloadall,Q_ref//Q_ref = 1 for reflectivity data (q), 0 for diffraction (angle)
	qloadall=2//only works one at a time
	variable row
	//Prompt qLoadAll,"Load all .udf files in a Folder? ",popup,"All .udf files in folder;User picks .udf files one at a time"	
	silent 1
	setdatafolder root:
	NewDataFolder/O/S Panalytical
	variable index=0,Counter, refno,size,DataAngleRange1,DataAngleRange2,ScanStepSize
	String LineOfNote,name,path,fullpath,HeaderText,windname,info
	string/g Root:Packages:P:gfilename,filename
			Open/R/T=".udf"/m=".udf(PC)  file only" refno as filename		
		counter=0
		filename=getfilename(s_filename)
		fullpath=s_filename
		HeaderText=filename+"\r\r"
		
		do//put initial lines in notes are of wave
			FReadLine refNo, LineOfNote					
			HeaderText=HeaderText+LineofNote			
			if (counter==0)
				info=lineofnote[12,42]
			endif
			if (counter==15)
				DataAngleRange1=str2num(lineofnote[15,23])//str2num(lineofnote)
				Print DataAngleRange1
				DataAngleRange2=str2num(lineofnote[26,33])
				Print DataAngleRange2
			endif
			if (counter==16)
				ScanStepSize=str2num(lineofnote[13,20])//str2num(lineofnote)	
				print ScanStepSIze
			endif
			Counter+=1	
		while (Counter<20)//total linees in Header
		name=filename[0,(strlen(filename)-5)]
		name="P"+name[0,31]
		
		name=cleanupName(name,0)	
		Name= AskName(name,name,30)
		close refno		
		NewdataFolder/O/S $name	
		string/g sampleinfo=info, basename=name[1,100]
		LoadWave/G/M/Q/O/D/A=wave/L={0,20,0,0,0} fullpath//data part
		variable rows=(((DataAngleRange2-DataAngleRange1)-scanStepSize)/ScanStepSize)/8
		variable cols=8
		print Rows
		make/o/n=(cols)  w2
		row=0
		make/o/n=0 w1	
		wave wave0
			do
				w2=wave0[row][p]
				ConcatenateWaves("w1", "w2")
				row=row+1				
		while (row<=floor(rows-1))		
		string rwavename="r"+name[1,32]
		string qwavename="q"+name[1,32]
		duplicate/o w1,$rwavename
		Note $rwavename HeaderText
		duplicate/o w1,$qwavename
		variable n=numpnts(w1)
		wave qwave=$qwavename
	
		qwave=DataAngleRange1+p*ScanStepSize
		
		if(Q_ref)//q_ref is 1 for refectivity panel
			qwave=((4*pi)/1.542)*sin((qwave/2)*(pi/180))//convert to q assumin CuKa
			NVAR Lambda=root:Packages:SASDataModification:ReflLambda
			Lambda=1.542
			SetScale/I x DataAngleRange1,DataAngleRange2,"", $rwavename
			Normalizereflectivity(rwavename)
		endif
		
		killwaves w1,w2,wave0
		index=index+1			
		
		//following display in new window
			//	Display/k=1/N=$name $rwavename vs $qwavename				
			//	ModifyGraph width=288,height=288
			//	windname=WinName(0,1)
			//	TextBox/W=$windname/N=text10/A=MT name
			//	DoUpdate	
			
		//followig displays in current window
	
		setdatafolder root:
end

Function ConvStr2Wv(str)
        string str
        variable numElements=ItemsInList(str , " ")
        make/O/N=(numElements) NewWv1
        variable i
        For(i=0;i<numElements;i+=1)
                NewWv1[i]=str2num(StringFromList(i, str , " "))
        endfor
end


functions/s stripEOL(inputstr)
	string inputstr
		if (stringmatch(inputstr, "!" )
			variable pos
			pos =strsearch(lineofnote,"!",0)-1
			
		endif
	return pos
end
			
			

function loadXRDml_Panalytical(qloadall,Q_ref)
	variable qloadall,Q_ref//Q_ref = 1 for reflectivity data (q), 0 for diffraction (angle)
	qloadall=2//only works one at a time
	variable row
	//Prompt qLoadAll,"Load all .udf files in a Folder? ",popup,"All .udf files in folder;User picks .udf files one at a time"	
	silent 1
	setdatafolder root:
	NewDataFolder/O/S PanalyticalReflectivity
	variable Counter, refno, start, stop,N
	Variable StartPosition,endposition, endstop, EOL
	String LineOfNote="",name,headertext,line=""
	string/g Root:Packages:P:gfilename,filename
		Open/R/T="????"/m=".xrdml  file only" refno as filename				
		filename=getfilename(s_filename)
		name=filename[0,(strlen(filename)-5)]
		name="P"+name[0,31]		
		name=cleanupName(name,0)	
		Name= AskName(name,name,30)	
		NewdataFolder/O/S $name	
		string/g basename=name[1,100]
		HeaderText=filename+"\r\r"
		counter=0
		do//put initial lines in notes are of wave
			HeaderText=HeaderText+LineofNote	
			FReadLine refNo, LineOfNote						
			if (strsearch(lineofnote,"<intensities unit=\"counts\">",0)!=-1)
				do
						EOL=strsearch(lineofnote,"!",0)//emailed files have "!" at line termination.  Need to reconstruct data from pieces.
						EOL=!(EOL==-1)//1 if "!" found
						IF (EOL)
							N=strlen(lineofnote)-3
							lineofnote=lineofnote[0,N]
						Endif
						FReadLine refNo, Line
						lineofnote+=line
				while (EOL)			
				start = strsearch(lineofnote,">",0)+1	//selects data string
				endstop = strsearch(lineofnote,"<",start)-1
				lineofnote=lineofnote[start, endstop]					
				break	
			endif
			counter+=1	
		while (1)	
		close refno		
		ConvStr2Wv(lineofnote)
		startposition =strsearch(HeaderText, "startPosition>", 50 )
		startposition+=14;endstop=startposition+7
		StartPosition= str2num( headertext[startposition, endstop])
		endposition =strsearch(HeaderText, "endPosition>", 50 )
		endposition+=12;endstop=endposition+7
		EndPosition=  str2num(headertext[endposition, endstop])

		string rwavename="r"+name[1,32]
		string qwavename="q"+name[1,32]
		duplicate/o NewWv1,$rwavename,$qwavename
		Note $rwavename HeaderText
		N=numpnts(NewWv1)
		wave qwave=$qwavename
		qwave=Startposition+p*(Endposition-Startposition)/(n-1)
		duplicate/o qwave qwaveangle	
		if(Q_ref)//q_ref is 1 for refectivity panel, other wise qwave is TTH
			qwave=((4*pi)/1.542)*sin((qwave/2)*(pi/180))//convert to q assumin CuKa
			NVAR Lambda=root:Packages:SASDataModification:ReflLambda
			Lambda=1.542
			SetScale/I x Startposition,Endposition,"", $rwavename//can plot vs angle using Display $rwavename
			Normalizereflectivity(rwavename)
			variable/g localqshift=0
			NVAR qshift=root:Packages:SASDataModification:qshift
			qshift=localqshift
		endif	
		killwaves NewWv1	
		KillStrings /Z root:PanalyticalReflectivity:filename		
		//following display in new window
				Display/k=1/N=$name $rwavename// vs $qwavename	
				Label bottom "TTH()"		
				Label left "Reflectivity"	
				//ModifyGraph width=288,height=288
				string windname=WinName(0,1)
				TextBox/W=$windname/N=text10/A=MT name
				ModifyGraph log(left)=1
				DoUpdate		
		setdatafolder root:
end
